function StartBattle(battle, background)
{
	if (battle.boss_battle)
	{
		;// Play boss music
	}
	if (!battle.boss_battle)
	{
		Battles.normal_music.play(true);
	}
	for (var i = 0; i < Game.psize; i ++)
	{
		Game.party[i].sta = 0;
		Game.party[i].bmenu = new Menu(true);
		for (var i2 = 0; i2 < 5; i2 ++)
		{
			Game.party[i].bmenu.addItem(Game.party[i].commands[i2], Game.party[i].endTurn);
		}
	}
	//Swish(2, 4000);
	Game.currentbattle = battle;
	battle.background = background;
	BattleLoop(battle);
}

function BattleLoop(battle)
{
	while (!IsKeyPressed(KEY_SPACE))
	{
		DrawBattle(battle);
		if (battle.starting == false)
		{
			UpdateBattle(battle);
		}
	}
	Battles.normal_music.stop();
	if (battle.winner == "Party")
	{
		// Battles.victory_music.play(repeat);
	}
	if (battle.winner == "Enemy")
	{
		// Battles.gameover_music.play(repeat);
	}
}

function DrawBattle(battle, commands)
{
	var dist = Game.psize * 66;
	battle.background.blit(0, 0);
	// Draw the enemy names and party info
	var ty = (battle.enemy.length-1) * 10;
	window.drawWindow(96, 215 - ty, 60, 8 + ty, true, "ENEMY(S)");
	for (var i = 0; i < battle.enemy.length; i ++)
	{
		Battles.unselected.blit(96, 217 - ty + (i * 10) + 1);
		font.drawText(103, 217 - ty + (i * 10), battle.enemy[i].name);
	}
	ty = (Game.psize - 1) * 10;
	window.drawWindow(170, 221 - ty, 141, 8 + ty, true, "PARTY");
	font.heading.drawText(227, 216 - ty, "HP");
	font.heading.drawText(250, 216 - ty, "MP");
	font.heading.drawText(269, 216 - ty, "STAMINA");
	for (var i = 0; i < Game.psize; i ++)
	{
		Battles.unselected.blit(170, 223 - ty + (i * 10) + 1);
		window.battleWindow(177, 223 - ty + (i * 10), i);
	}
	if (battle.situation != "Time")
	{
		if (commands == true || commands == undefined)
		{
			if (battle.situation < Game.psize)
			{
				Game.party[battle.situation].bmenu.execute(20, 181, 60, 5);
			}
		}
	}
	if (battle.starting == true)
	{
		Fade(battle.alpha, Colors.Black);
		battle.alpha -= 5;
		if (battle.alpha < 0)
		{
			battle.starting = false;
		}
	}
	FlipScreen();
}

function UpdateBattle(battle)
{
	if (battle.situation == "Time")
	{
		for (var i = 0; i < Game.psize; i ++)
		{
			if (Game.party[i].hp > 0)
			{
				Game.party[i].sta += Game.party[i].starec;
				if (Game.party[i].sta >= 1000)
				{
					Game.party[i].sta = 1000;
					Game.party[i].turn = true;
					if (battle.situation != "Turn")
					{
						battle.situation = i;
					}
				}
			}
		}
	}
}

function Battle(boss)
{
	this.boss_battle = boss;
	this.finished = false;
	this.winner;
	this.situation = "Time";
	this.enemy = new Array();
	this.exp = 0;
	this.money = 0;
	this.ap = 0;
	this.alpha = 255;
	this.starting = true;
}

Battle.prototype.addEnemy = function(enemy)
{
	this.enemy[this.enemy.length] = enemy.clone();
}

function Targeter(x, y, battle)
{
	var targets = new Array();
	var targeter_open = true;
	var side = battle.enemy;
	var selection = 0;
	while (targeter_open)
	{
		DrawBattle(battle, false);
		FlipScreen();
		if (AreKeysLeft())
		{
			switch (GetKey())
			{
				case Game.accept:
				{
					if (targets.length > 0)
					{
						targeter_open = false;
						return targets;
					}
					break;
				}
				case Game.cancel:
				{
					break;
				}
				case Game.menu:
				{
					targets[targets.length] = side[selection];
					break;
				}
				case KEY_UP:
				{
					break;
				}
				case KEY_DOWN:
				{
					break;
				}
				case KEY_LEFT:
				{
					break;
				}
				case KEY_RIGHT:
				{
					break;
				}
			}
		}
	}
}

// Following are ALL the battles in the game (No peeking, cheaters!)

var Battles = new Object();
Battles.normal_music = LoadSound("Battle.it");
Battles.victory_music;
Battles.gameover_music;
Battles.selected = LoadImage("Battle-Selected.png");
Battles.unselected = LoadImage("Battle-Unselected.png");
Battles.Plains = LoadImage("Plains-BG.png");
Battles.Test1 = new Battle(false);
Battles.Test1.addEnemy(Enemies.Shitake);
